#define STRICT

#include <windows.h>
//#include <windowsx.h>
#include "resource.h"

HINSTANCE g_hinstDll = NULL;
HANDLE hLocMap = NULL;
LPVOID pLocMap = NULL;
LPVOID pRemMap = NULL;
#pragma data_seg("Shared")
DWORD mySize = 0;
HHOOK g_hhook = NULL;
DWORD g_dwThreadIdSoftDump = 0;
HANDLE hRemMap = NULL;
#pragma data_seg()
#pragma comment(linker, "/section:Shared,rws")
extern "C" 
{
	__declspec(dllexport) DWORD SetMapHook(HANDLE hMap, DWORD nSize, DWORD dwThread);
}

BOOL CALLBACK SetMap_DlgProc(HWND hwnd, UINT uMsg, 
							 WPARAM wParam, LPARAM lParam) 
{
	
	switch (uMsg) 
	{
		
	case WM_CLOSE:
		UnmapViewOfFile(pLocMap);
		CloseHandle(hLocMap);
		UnhookWindowsHookEx(g_hhook);
		DestroyWindow(hwnd);
		return (FALSE);
		break;
		
	}
	return(FALSE);	
}

BOOL WINAPI DllMain (HINSTANCE hinstDll, DWORD fdwReason, LPVOID fImpLoad) 
{
	
	switch (fdwReason) {
		
	case DLL_PROCESS_ATTACH:
		// DLL is attaching to the address space
		// of the current process.
		g_hinstDll = hinstDll;
		break;
		
	case DLL_THREAD_ATTACH:
		// A new thread is being created
		// in the current process.
		break;
		
	case DLL_THREAD_DETACH:
		// A thread is exiting cleanly.
		break;
		
	case DLL_PROCESS_DETACH:
		// The calling process is detaching the
		// DLL from its address space.
		break;
	}
	return(TRUE);
}

LRESULT WINAPI GetMsgProc (int nCode, WPARAM wParam, LPARAM lParam) 
{
	
	static BOOL fFirstTime = TRUE;
	DWORD dwLastErr=0;
	
	if (fFirstTime) {
		// The DLL just got injected.
		fFirstTime = FALSE;
		
		// Create the dialog to receive msgs from softdump.exe
		CreateDialog(g_hinstDll, MAKEINTRESOURCE(IDD_SETMAP), 
			NULL, SetMap_DlgProc);

		// Map the File
		hLocMap = OpenFileMapping(PAGE_READWRITE, TRUE, "softmap");
		pLocMap = MapViewOfFile ( hLocMap, FILE_MAP_READ, 0, 0, 0);
		if (!pLocMap)
		{
			dwLastErr = GetLastError();
		} else {
			for (BYTE* i = (BYTE*) pLocMap; i < (BYTE*)((DWORD)pLocMap+mySize); i++)
				BYTE x=*i;
			dwLastErr = 0;
		}
		// Tell the DIPS application that the server is
		// up and ready to handle requests.
		PostThreadMessage(g_dwThreadIdSoftDump, WM_APP, dwLastErr, (DWORD)pLocMap);
	}
	
	return(CallNextHookEx(g_hhook, nCode, wParam, lParam));
}

// SetMapHook is called from within softdump.exe's address space

DWORD SetMapHook(HANDLE hMap, DWORD nSize, DWORD dwTargetThread) 
{
	BOOL fOk = FALSE;
	
	hRemMap = hMap;
	mySize = nSize;
	// get thread id for softdump.exe
	g_dwThreadIdSoftDump = GetCurrentThreadId();
	// Install the hook on the specified thread
	g_hhook = SetWindowsHookEx(WH_GETMESSAGE, GetMsgProc, 
		g_hinstDll, dwTargetThread);
	return(!g_hhook);
}

